<?php
// Tests how absolute/relative/current paths are corrected in embedded documents.

class UiduPager extends UWikiPagerStub {
  function ReadPage($file, $format = null) { return $GLOBALS['iduIncludes'][$file]; }
}


  $GLOBALS['iduIncludes'] = array('/abs/path/sub' => '((abs-link))',
                                  'rel/path/sub' => '((rel-link))');

  $src = '
{{include /abs/path/sub}}
{{include rel/path/sub}}
((base-link))
';
  $doc = new UWikiDocument($src);
  $doc->settings = $settings;
  $doc->settings->pager = new UiduPager;
  $doc->settings->rootURL = '/root/path/';
  $doc->settings->BaseURL('base/path');
  $doc->LoadMarkup('wacko');

  $doc->Parse();
  $html = $doc->ToHTML();

$expectedHTML = '
<a name="abs" href="#abs" title="#abs" class="anchor include block-anchor">
¶
</a>
<p class="default">
<a href="/root/path/abs/path/abs-link" title="abs-link" class="round-brackets internal">abs-link</a>
<a name="p_0-1" href="#p_0-1" title="#p_0-1" class="anchor">¶</a>
</p>
<a name="rel" href="#rel" title="#rel" class="anchor include block-anchor">
¶
</a>
<p class="default">
<a href="/root/path/base/path/rel/path/rel-link" title="rel-link" class="round-brackets internal">rel-link</a>
<a name="p_0-2" href="#p_0-2" title="#p_0-2" class="anchor">¶</a>
</p>
<p class="default">
<a href="/root/path/base/path/base-link" title="base-link" class="round-brackets internal">base-link</a>
<a name="p_0-3" href="#p_0-3" title="#p_0-3" class="anchor">¶</a>
</p>
';

  TestEquality( preg_replace('/(\r?\n)+/u', "\n", trim($html)), trim($expectedHTML) );
